//precision highp float;

uniform vec2 u_cellUVSize;
uniform vec2 u_gridUVSize;

varying vec2 v_texCoord;
varying vec2 v_cellTexCoord;

void main()
{
    vec2 snappedCellTexCoord = (floor(v_texCoord / u_cellUVSize ) + 0.5 ) * u_cellUVSize * u_gridUVSize;
    vec4 cellCol = texture2D(CC_Texture1, snappedCellTexCoord);
    vec4 attCol = texture2D(CC_Texture2, snappedCellTexCoord);
    cellCol.a *= attCol.a;
    
    gl_FragColor = cellCol;
}
